/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.editor;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.php.epl.PHPEplPlugin;
import com.aptana.editor.php.internal.ui.editor.ScriptMarkerAnnotation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class SourceModuleAnnotationModelEvent
extends AnnotationModelEvent {
    private boolean fIncludesProblemMarkerAnnotations;
    private IResource fUnderlyingResource;

    public SourceModuleAnnotationModelEvent(IAnnotationModel model, IResource underlyingResource) {
        super(model);
        this.fUnderlyingResource = underlyingResource;
        this.fIncludesProblemMarkerAnnotations = false;
    }

    private void testIfProblemMarker(Annotation annotation) {
        if (this.fIncludesProblemMarkerAnnotations) {
            return;
        }
        if (annotation instanceof ScriptMarkerAnnotation) {
            this.fIncludesProblemMarkerAnnotations = ((ScriptMarkerAnnotation)annotation).isProblem();
        } else if (annotation instanceof MarkerAnnotation) {
            try {
                IMarker marker = ((MarkerAnnotation)annotation).getMarker();
                if (!marker.exists() || marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                    this.fIncludesProblemMarkerAnnotations = true;
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)PHPEplPlugin.getDefault(), (String)"Error getting a PHP error marker", (Throwable)e);
            }
        }
    }

    public void annotationAdded(Annotation annotation) {
        super.annotationAdded(annotation);
        this.testIfProblemMarker(annotation);
    }

    public void annotationRemoved(Annotation annotation) {
        super.annotationRemoved(annotation);
        this.testIfProblemMarker(annotation);
    }

    public void annotationRemoved(Annotation annotation, Position position) {
        super.annotationRemoved(annotation, position);
        this.testIfProblemMarker(annotation);
    }

    public void annotationChanged(Annotation annotation) {
        this.testIfProblemMarker(annotation);
        super.annotationChanged(annotation);
    }

    public boolean includesProblemMarkerAnnotationChanges() {
        return this.fIncludesProblemMarkerAnnotations;
    }

    public IResource getUnderlyingResource() {
        return this.fUnderlyingResource;
    }
}

